/* 
 *  SetActivityCodeRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;

public class SetActivityCodeRequest extends InteractionRequest {

    private static final Logger LOG = Logger.getLogger(SetActivityCodeRequest.class);
    private final String activityCode;

    public SetActivityCodeRequest(String interactionID, String activityCode) {
        super(LOG, interactionID);
        this.activityCode = activityCode;
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        getInteraction().setActivityCode(this.activityCode);
        LOG.trace(methodName + "-");
        return null;
    }
}
